using System;
using System.Collections;
using System.Windows.Forms;

namespace gov.va.med.vbecs.GUI.controls
{
		#region Header
	/// <summary>
	/// Allows sorting of listviews
	/// </summary>
	///<remarks>
	///<newpara> Package: VBECS - VistA Blood Establishment Computer System</newpara>
	///<newpara> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</newpara>
	///<newpara> Medical Device #: $MEDDEVICENO</newpara>
	///<newpara> Date Created: 4/30/2002</newpara>
	///<newpara> Site Name: Hines OIFO </newpara>
	///<newpara> Developers: Luke Meyer</newpara>
	///<newpara> Note: The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</newpara>
	///</remarks>
	#endregion

	public class SortBySubItem : IComparer
	{
		private int m_subItem = 0;

		#region Methods

		/// <summary>
		/// Assigns module-level sub-item variable to passed-in parameter
		/// </summary>
		///<param name="subItem">Int</param>
		///<returns>N/A</returns>
		///<remarks>
		///<newpara> Constructor: SortBySubItem</newpara>
		///<newpara> Developers: Luke Meyer</newpara>
		///<newpara> Site Name: Hines OIFO </newpara>
		///<newpara> Date Created: 4/30/2002</newpara>
		///</remarks>
		public SortBySubItem(int subItem)
		{
			m_subItem = subItem;
		}


		#endregion

		#region Properties

		/// <summary>
		/// Returns subitem
		/// </summary>
		///<remarks>
		///<newpara> SubItem</newpara>
		///<newpara> Developers: Luke Meyer</newpara>
		///<newpara> Site Name: Hines OIFO </newpara>
		///<newpara> Date Created: 4/30/2002</newpara>
		///</remarks>
		public int SubItem
		{
			get
			{return m_subItem;}
			set
			{m_subItem = value;}
		}


		/// <summary>
		/// Compares two objects and returns a value indicating whether one is less than, equal to or greater than the other.
		/// </summary>
		/// <param name="o1"></param>
		/// <param name="o2"></param>
		/// <returns></returns>
		int IComparer.Compare(object o1, object o2)
		{
			ListViewItem item = (ListViewItem)o1;
			ListViewItem item2 = (ListViewItem)o2;

			int ret = String.Compare(item.SubItems[m_subItem].Text,
				item2.SubItems[m_subItem].Text);
			return ret;
		}

		#endregion
	}
}
